%%Matlab file that produces Table 1 from Mankiw and Weinzierl, "An
%%Exploration of Optimal Stabilization Policy," Brookings Papers on
%%Economic Activity, 2011.

%% Setup
close all
clear all
warning off
options=optimset('Jacobian','off','TolCon',1e-12,'TolFun',1e-12,'TolX',1e-12,'Display','iter','MaxFunEvals',10000000,'MaxIter',20000); 

%Model Parameters (other than shock value, which is further below)
%Setting up the starting point
beta=1/(1.05);
delta=1;
gamma=2; %Paper uses sigma=1/gamma. So, if baseline sigma=0.5, baseline gamma=2
theta=0.24^gamma; %Paper uses v(G)=theta^(1/sigma)*f(G), where f(G) is a CRRA function.
%In these calculation files, the utility function is v(G)=theta*f(G). So,
%when the paper calibrates theta=x, the equivalent expression here should
%be theta=x^(1/sigma)=x^gamma
A1=1/beta;
A2base=1/beta;
K1=100;
i2base=0.05;
M2base=1.00;

%Now, we want to start in a situation where the nominal interest rate is at
%zero, which requires A2 to fall such that the given M2 yields full
%employment at i2=0.  This A2 is the conventional threshold:
A2conventionalthreshold= ((1/(beta*A2base))^(1/gamma)*A2base-i2base/...
                         ((1/(beta))^(1/gamma)*(1+i2base)))...
                         ^(gamma/(gamma-1));
                     
%Pre-shock values are then     
M2pre=M2base;
A2pre=A2conventionalthreshold;
i2pre=0.00;
    C1pre=(1/(beta*A2pre))^(1/gamma)*A2pre/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    C2pre=A2pre/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    K2pre=1/((1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    I1pre=K2pre;
    I2pre=0;
    G1pre=theta^(1/gamma)*C1pre;
    G2pre=theta^(1/gamma)*C2pre;
    Y1ADpre=C1pre+I1pre+G1pre;
    Y1ASpre=A1*K1;
    Y2ADpre=C2pre+I2pre+G2pre;
    Y2ASpre=A2pre*K2pre;
    P2pre=M2pre/C2pre;
    P1pre=A2pre/((1+i2pre)/P2pre);
    M1pre=P1pre*C1pre;
    T1pre=G1pre;
    T2pre=G2pre;
    Welfarepre=1/(1-gamma)*(C1pre^(1-gamma)+theta*G1pre^(1-gamma))+...
                beta*1/(1-gamma)*(C2pre^(1-gamma)+theta*G2pre^(1-gamma));

%The shock lowers A2
shock=.25; %Baseline is 0.25
A2=(1-shock)*A2pre;

%Monetary Policy is unchanged
M2=M2base;
i2=0.00;
%% %Case 1: Flexible-price allocation with optimal fiscal policy
for i=1
    C1(i)=(1/(beta*A2))^(1/gamma)*A2/((1+theta^(1/gamma))*(1+(1/(beta*A2))^(1/gamma)*A2))*A1*K1;
    C2(i)=A2/((1+theta^(1/gamma))*(1+(1/(beta*A2))^(1/gamma)*A2))*A1*K1;
    K2(i)=1/((1+(1/(beta*A2))^(1/gamma)*A2))*A1*K1;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=theta^(1/gamma)*C1(i);
    G2(i)=theta^(1/gamma)*C2(i);
    Y1AD(i)=C1(i)+I1(i)+G1(i);
    Y1AS(i)=A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2(i);
    Y2AS(i)=A2*K2(i);
    P2(i)=M2/C2(i);
    P1(i)=A2/((1+i2)/P2(i));
    M1(i)=P1(i)*C1(i);
    T1(i)=G1(i);
    T2(i)=G2(i);
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1(i)^(1-gamma))+...
                beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2(i)^(1-gamma));
end

%% %Sticky-price models when monetary policy is restricted (unable to achieve
%flexible-price equilibrium). We consider several possible fiscal policy
%responses.

%% %Case 2: Inactive fiscal policy: G1 and G2 are the same shares of 
%output as in the pre-shock equilibrium (note that output may not be stabilized)
for i=2  
    C1(i)=(1/(beta*A2))^(1/gamma)*A2*M2/((1+i2)*P1pre);
    C2(i)=A2*M2/((1+i2)*P1pre);
    K2(i)=M2/((1+i2)*P1pre)+G2pre/A2;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=G1pre;
    G2(i)=G2pre;
    Y1AD(i)=C1(i)+I1(i)+G1pre;
    Y1AS(i)= A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2pre;
    Y2AS(i)=A2*K2(i);
    P1(i)=P1pre;
    P2(i)=M2/C2(i);
    P2check(i)=(1+i2)*1/A2*P1pre;
    M1(i)=P1pre*C1(i);
    T1(i)=G1pre;
    T2(i)=G2pre;
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1(i)^(1-gamma))+...
               beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2(i)^(1-gamma));
    
end
if Y1AD(2)>Y1AS(2)
   'stop--AD exceeds AS' 
   pause
else end

%% %Case 3: First-period government purchases only, G2 at preshock level, no
%%%investment subsidy
for i=3
    C1(i)=(1/(beta*A2))^(1/gamma)*A2*M2/((1+i2)*P1pre);
    C2(i)=A2*M2/((1+i2)*P1pre);
    K2(i)=M2/((1+i2)*P1pre)+G2pre/A2;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=A1*K1-(C1(i)+I1(i));
    G2(i)=G2pre;
    Y1AD(i)=C1(i)+I1(i)+G1(i);
    Y1AS(i)= A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2pre;
    Y2AS(i)=A2*K2(i);
    P1(i)=P1pre;
    P2(i)=M2/C2(i);
    P2check(i)=(1+i2)*1/A2*P1pre;
    M1(i)=P1pre*C1(i);
    T1(i)=T1pre;
    T2(i)=A2*(G1(i)-T1(i))+G2(i);
    Stimulus(i)=(G1(i)-G1(2))+1/(A2)*(G2(i)-G2(2));
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1(i)^(1-gamma))+...
               beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2(i)^(1-gamma));
end

%% %Case 4: Optimal government purchases, no investment subsidy
for i=4
    C1(i)=(1+i2pre)/(1+i2)*(1/(beta*A2))^(1/gamma)*A2 / ((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    C2(i)=(1+i2pre)/(1+i2)*A2 /                         ((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    K2(i)=1/(1+(1/(beta*A2))^(1/gamma)*A2)*A1*K1;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=(1/(beta*A2))^(1/gamma)*A2/(1+(1/(beta*A2))^(1/gamma)*A2)*...
                (1-(1+i2pre)/(1+i2)*(1+(1/(beta*A2))^(1/gamma)*A2)/...
                ((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre)))*...
                A1*K1;
    G2(i)=A2/(1+(1/(beta*A2))^(1/gamma)*A2)*...
                (1-(1+i2pre)/(1+i2)*(1+(1/(beta*A2))^(1/gamma)*A2)/...
                ((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre)))*...
                A1*K1;
    Y1AD(i)=C1(i)+I1(i)+G1(i);
    Y1AS(i)= A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2(i);
    Y2AS(i)=A2*K2(i);
    P1(i)=P1pre;
    P2(i)=M2/C2(i);
    P2check(i)=(1+i2)*1/A2*P1(i);
    M1(i)=P1(i)*C1(i);
    T1(i)=T1pre;
    T2(i)=A2*(G1(i)-T1(i))+G2(i);
    Stimulus(i)=(G1(i)-G1(2))+1/(A2)*(G2(i)-G2(2));
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1(i)^(1-gamma))+...
               beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2(i)^(1-gamma));
end


%% %Case 5: Full employment investment subsidy, government purchases fixed
%%%at preshock levels
for i=5
    guess=[.1];
    lb=[ 0];
    ub=[1];
   %%%Optimization execution
    [z,fval,exitflag,output]=fmincon('s1onlyobj022811',guess,[],[],[],[],lb,ub,...
                                        's1onlyconstr022811',options,gamma,beta,theta,...
                                        G1pre,A1,K1,G2pre,A2,i2,M2,P1,i2pre,A2pre,P1pre,Y1ADpre,Y2ADpre,i);
    s1(i)=z(1);
    
    C1(i)=((1-s1(i))/(beta*A2))^(1/gamma)*A2/(1-s1(i))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    C2(i)=A2/(1-s1(i))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    K2(i)=1/(1-s1(i))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1+G2pre/A2;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=G1pre;
    G2(i)=G2pre;
    Y1AD(i)=C1(i)+I1(i)+G1pre;
    Y1AS(i)= A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2pre;
    Y2AS(i)=A2*K2(i);
    P1(i)=P1pre;
    P2(i)=M2/C2(i);
    P2check(i)=(1+i2)*1/A2*P1(i);
    M1(i)=P1(i)*C1(i);
    T1(i)=T1pre;
    T2(i)=A2*(G1(i)+s1(i)*I1(i)-T1(i))+G2(i);
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1pre^(1-gamma))+...
               beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2pre^(1-gamma));
    Stimulus(i)=(s1(i)*I1(i)+G1(i)-G1(2))+1/(A2)*(G2(i)-G2(2));
end


%% %Case 6: Optimal policy mix
for i=6
    guess=[.1; G1(1)/Y1AD(1); G2(1)/Y2AD(1)];
    lb=[ 0;0;0];
    ub=[1;1;1];
   %%%Optimization execution
    [z,fval,exitflag,output]=fmincon('s1obj022811',guess,[],[],[],[],lb,ub,...
                                        's1constr022811',options,gamma,beta,theta,...
                                        G1,A1,K1,G2,A2,i2,M2,P1,i2pre,A2pre,P1pre,i);
    s1(i)=z(1);
    g1(i)=z(2);
    g2(i)=z(3);
    
    C1(i)=((1-s1(i))/(beta*A2))^(1/gamma)*A2/(1-s1(i))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    C2(i)=A2/(1-s1(i))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    K2(i)=1/((1-g2(i))*(1-s1(i)))*...
               ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=g1(i)*A1*K1;
    G2(i)=g2(i)*A2*K2(i);
    Y1AD(i)=C1(i)+I1(i)+G1(i);
    Y1AS(i)= A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2(i);
    Y2AS(i)=A2*K2(i);
    P1(i)=P1pre;
    P2(i)=M2/C2(i);
    P2check(i)=(1+i2)*(1-s1(i))*1/A2*P1(i);
    M1(i)=P1(i)*C1(i);
    T1(i)=T1pre;
    T2(i)=A2*(G1(i)+s1(i)*I1(i)-T1(i))+G2(i);
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1(i)^(1-gamma))+...
               beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2(i)^(1-gamma));
    Stimulus(i)=(s1(i)*I1(i)+G1(i)-G1(2))+1/(A2)*(G2(i)-G2(2));
end

%% %Case 7: Optimal policy mix with non-Ricardians
lambda=0.5;
rho=(1/(beta*A2pre))^(1/gamma)*A2pre/(1+theta^(1/gamma)+(1/(beta*A2pre))^(1/gamma)*A2pre);
for i=7
    guess=[.1; G1(1)/Y1AD(1); G2(1)/Y2AD(1)];
    lb=[ 0;0;0];
    ub=[1;1;1];
   %%%Optimization execution
    [z,fval,exitflag,output]=fmincon('s1nonRicobj022811',guess,[],[],[],[],lb,ub,...
                                        's1nonRicconstr022811',options,gamma,beta,theta,lambda,rho,...
                                        G1,A1,K1,G2,A2,i2,M2,P1,i2pre,A2pre,P1pre,i);
    s1(i)=z(1);
    g1(i)=z(2);
    g2(i)=z(3);
    
    C1(i)=((1-g1(i))-1/((1-s1(i))*(1-g2(i)))*((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre)))*A1*K1;
    C2(i)=A2/(1-s1(i))*                      ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    K2(i)=1/((1-g2(i))*(1-s1(i)))*           ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre))*A1*K1;
    I1(i)=K2(i);
    I2(i)=0;
    G1(i)=g1(i)*A1*K1;
    G2(i)=g2(i)*A2*K2(i);
    Y1AD(i)=C1(i)+I1(i)+G1(i);
    Y1AS(i)= A1*K1;
    Y2AD(i)=C2(i)+I2(i)+G2(i);
    Y2AS(i)=A2*K2(i);
    P1(i)=P1pre;
    P2(i)=M2/C2(i);
    P2check(i)=(1+i2)*(1-s1(i))*1/A2*P1(i);
    M1(i)=P1(i)*C1(i);
    T1(i)=A1*K1/(lambda*rho*(1+((1-s1(i))/(beta*A2))^(1/gamma)*A2/(1-s1(i))))*...
            ( (1+lambda*rho*((1-s1(i))/(beta*A2))^(1/gamma)*A2/(1-s1(i)))*g1(i)-(1-lambda*rho)+...
              (1+((1-s1(i))/(beta*A2))^(1/gamma)*A2*((1-lambda*rho)*(1-g2(i))+lambda*rho*s1(i)/(1-s1(i))))/...
                ((1-g2(i))*(1-s1(i)))*...
                    ((1+i2pre)/(1+i2))/((1+theta^(1/gamma))*(1+(1/(beta*A2pre))^(1/gamma)*A2pre)) );
                

	T1alt(i)=A1*K1*(1/(lambda*rho*(1+((((1-s1(i)))/(A2*beta)))^(1/gamma)*((A2)/((1-s1(i)))))))*...
            ((1+lambda*rho*((((1-s1(i)))/(A2*beta)))^(1/gamma)*((A2)/((1-s1(i)))))*g1(i)-(1-lambda*rho)+...
            ((1+((((1-s1(i)))/(A2*beta)))^(1/gamma)*A2*((1-lambda*rho)*(1-g2(i))+lambda*rho*((s1(i))/(1-s1(i)))))/...
            ((1-s1(i))*(1-g2(i))))*(((1+i2pre))/((1+(theta)^(1/gamma))*(1+((1/(beta*A2pre)))^(1/gamma)*A2pre))));
              
    T2(i)=G2(i)-A2/(1-s1(i))*(T1(i)-G1(i)-s1(i)*I1(i));
    C1rot=rho*(Y1AD(i)-T1(i));
    C2rot=rho*(Y2AD(i)-T2(i));
    C1rat=1/(1-lambda)*(C1(i)-lambda*C1rot);
    C2rat=1/(1-lambda)*(C2(i)-lambda*C2rot);
    Eulercheck(i)=(C1rat/C2rat)^-gamma-beta*(1+i2)*P1(i)/P2(i);
    Welfare(i)=1/(1-gamma)*(C1(i)^(1-gamma)+theta*G1(i)^(1-gamma))+...
               beta*1/(1-gamma)*(C2(i)^(1-gamma)+theta*G2(i)^(1-gamma));
    Stimulus(i)=(s1(i)*I1(i)+G1(i)-G1(2))+1/(A2)*(G2(i)-G2(2));
end

for i=1:6
    Eulercheck(i)=(C1(i)/C2(i))^-gamma-beta*(1+i2)*P1(i)/P2(i);
end

C1
C2
I1
G1
G2
Y1AD
Y1AS
Y2AD
Y2AS
Stimulus
Welfare

I=length(C1);
%% Now, calculate the fiscal multipler (Bang for the Buck) and
%the welfare gains of policy.
for i=1:I;
guess=1.1;
    gain(i)=fsolve('welfaregainsolve',guess,options,gamma,beta,theta,...
                    C1,C2,G1,G2,Welfare,i);
    Welfaregain(i)=(gain(i)-1)*C1(2);
    Outputgain(i)=(Y1AD(i)-Y1AD(2))+(1/A2)*(Y2AD(i)-Y2AD(2));  
    Y1gain(i)=(Y1AD(i)-Y1AD(2));
    Deficit(i)=(G1(i)+s1(i)*I1(i)-T1(i));
    Welfarecalc(i)=1/(1-gamma)*((gain(i)*C1(2))^(1-gamma)+theta*G1(2)^(1-gamma))+...
                beta*1/(1-gamma)*((C2(2))^(1-gamma)+theta*G2(2)^(1-gamma));
end
for i=1:I;
    Y1forbuck(i)=Y1gain(i)/Deficit(i);
end
%Show results
[   gain-1
    Y1forbuck]
